REBOL [
	subject: "serveur multi-connexion"
	author: "Olivier Auverlot"
]

fichier: read/lines %donnees.dat
clients: []

deconnexion: does [
	close c/port
	remove clients
]

io-port: open tcp://:8000

forever [
	if not (none? (wait [ 0 io-port ])) [
		; nouvelle connexion
		append clients make object! [
			port: first io-port
			etape: 1
			debut: 0
			fin: 0
		]
	]

	; si des clients sont connects
	; le serveur gre leurs demandes
	clients: head clients
	while [ (length? clients) > 0 ] [
		c: first clients
		either query c/port [
			either c/etape = 1 [
				; on rcupre la requte du client
				buffer: copy ""
				until [
					data: copy ""
					len: read-io c/port data 255
					append buffer data
					any [ (found? find data "^/") (len = 0) ]
				]
				either len = 0 [
					; connexion ferme par le client
					deconnexion
				] [ 
					; dcoupe de la requte
					requete: parse (trim buffer) "-"
					c/debut: to-integer first requete
					c/fin: to-integer second requete
					; on dclenche l'excution pour le client
					c/etape: 2
				]
			] [
				; on traite la requte du client
				either c/debut <= c/fin [
					insert c/port pick fichier c/debut
					c/debut: c/debut + 1
				] [ 
					;fin du traitement
					deconnexion
				]
			]
		] [
			; si la connexion a t rompue
			; on libre le port
			deconnexion			
		]
		clients: next clients
	]
]